uniform sampler2D 			posTex;
uniform sampler2DShadow 	shadowmap;
uniform sampler2DShadow 	shadowmap2;
uniform sampler2DShadow 	shadowmap4;
uniform sampler2DShadow 	shadowmap8;

varying vec2 		texcoord;
uniform float 		lightrange;
uniform float 		lightrange2;
uniform float 		lightrange4;
uniform float 		lightrange8;
uniform float		cOfs;

uniform int 		split0;
uniform int 		split2;
uniform int 		split4;
uniform int 		split8;

uniform vec4		LTM0,
					LTM1,
					LTM2,
					LTM3;

uniform vec4		LTM0b,
					LTM1b,
					LTM2b,
					LTM3b;

uniform vec4		LTM0c,
					LTM1c,
					LTM2c,
					LTM3c;

uniform vec4		LTM0d,
					LTM1d,
					LTM2d,
					LTM3d;

varying vec2		VPOS;

void main()
{
	vec2	Zproj;
	vec4	XYproj;	

	vec4 pos = texture2D(posTex,texcoord.st);
	pos.xy=VPOS.xy*-pos.z;
	pos.w=1.0;

	float shadowOcc=1.0;
	gl_FragColor.r=1.0;//vec4(1.0,1.0,1.0,1.0);
	
	vec3 projcoords;
	if( -pos.z/lightrange <= 1.0 )
	{
		/*if(split0==0)
			discard;
			*/
		// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
		XYproj.x = dot(pos,LTM0);
		XYproj.y = dot(pos,LTM1);
		XYproj.z = dot(pos,LTM2);
		XYproj.w = dot(pos,LTM3);

		projcoords.xy=XYproj.xy;
		projcoords.z=XYproj.z-0.00005;
		///////////////////////////////////

		float dOfs = cOfs*0.5;
		shadowOcc=0.0;

		vec3 shadowcoords;
		shadowcoords.z=projcoords.z;

		shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
		shadowOcc+=shadow2D(shadowmap,shadowcoords).r;
	
		shadowOcc *= 0.25;
		if(shadowOcc>0.0)
			if(shadowOcc<1.0)
				shadowOcc= 0.5;	
		gl_FragColor.r*=shadowOcc;
	}
	else
	{	
		if( -pos.z/lightrange2 <= 1.0 )
		{
			/*if(split2==0)
				discard;
			*/
			// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
			XYproj.x = dot(pos,LTM0b);
			XYproj.y = dot(pos,LTM1b);
			XYproj.z = dot(pos,LTM2b);
			XYproj.w = dot(pos,LTM3b);

			projcoords.xy=XYproj.xy;
			projcoords.z=XYproj.z-0.0004;
			///////////////////////////////////

			float dOfs = cOfs*0.5;
			shadowOcc=0.0;

			vec3 shadowcoords;
			shadowcoords.z=projcoords.z;

			shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
			shadowOcc+=shadow2D(shadowmap2,shadowcoords).r;

			shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
			shadowOcc+=shadow2D(shadowmap2,shadowcoords).r;

			shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
			shadowOcc+=shadow2D(shadowmap2,shadowcoords).r;

			shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
			shadowOcc+=shadow2D(shadowmap2,shadowcoords).r;
	
			shadowOcc *= 0.25;
			if(shadowOcc>0.0)
				if(shadowOcc<1.0)
					shadowOcc= 0.5;
			gl_FragColor.r*=shadowOcc;
		}
		else
		{
			if( -pos.z/lightrange4 <= 1.0 )
			{
				/*if(split4==0)
					discard;
				*/
				// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
				XYproj.x = dot(pos,LTM0c);
				XYproj.y = dot(pos,LTM1c);
				XYproj.z = dot(pos,LTM2c);
				XYproj.w = dot(pos,LTM3c);

				projcoords.xy=XYproj.xy;
				projcoords.z=XYproj.z-0.0006;
				///////////////////////////////////

				float dOfs = cOfs*0.5;
				shadowOcc=0.0;

				vec3 shadowcoords;
				shadowcoords.z=projcoords.z;

				shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
				shadowOcc+=shadow2D(shadowmap4,shadowcoords).r;

				shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
				shadowOcc+=shadow2D(shadowmap4,shadowcoords).r;

				shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
				shadowOcc+=shadow2D(shadowmap4,shadowcoords).r;

				shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
				shadowOcc+=shadow2D(shadowmap4,shadowcoords).r;
	
				shadowOcc *= 0.25;
				if(shadowOcc>0.0)
					if(shadowOcc<1.0)
						shadowOcc= 0.5;
				gl_FragColor.r*=shadowOcc;
			}
			else
			{
				if( -pos.z/lightrange8 <= 1.0 )
				{
					/*if(split8==0)
						discard;
					*/
					// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
					XYproj.x = dot(pos,LTM0d);
					XYproj.y = dot(pos,LTM1d);
					XYproj.z = dot(pos,LTM2d);
					XYproj.w = dot(pos,LTM3d);

					projcoords.xy=XYproj.xy;
					projcoords.z=XYproj.z-0.002;
					///////////////////////////////////

					float dOfs = cOfs*0.5;
					shadowOcc=0.0;

					vec3 shadowcoords;
					shadowcoords.z=projcoords.z;

					shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
					shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;

					shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
					shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;

					shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
					shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;

					shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
					shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;
	
					shadowOcc *= 0.25;
					
					float lrangeMin=lightrange8-1000.0;
					shadowOcc=mix(shadowOcc,1.0,( clamp( (-pos.z-lrangeMin)/(lightrange8-lrangeMin),0.0,1.0) ));
					
					if(shadowOcc>0.0)
						if(shadowOcc<1.0)
							shadowOcc= 0.5;
					gl_FragColor.r*=shadowOcc;
				}
			}
		}
	}
	gl_FragColor.r=max(gl_FragColor.r,0.0);
}
